function config=load_experiment_config(config_fname)

%% Read inputs
txt=fileread(config_fname);
config=jsondecode(txt);
save_fname=[config.dataset_id,'_input.mat'];

% Check if the data has been processed before
if isfile(save_fname)
    warning([save_fname,' exists. Overwrite existing configuration records?(Y/N)']);
    x=input('','s');
    if x=='Y'||x=='y'
        % save inputs for record keeping and for a01
        fprintf('Overwrite configuration records and continue with processing.\n');
        config=process_input(config,save_fname);
    elseif x=='N'||x=='n'
        fprintf('Loading existing configuration records and reprocess using the same configuration.\n');
        S=load(save_fname);
        config=S.config;
    end
else
    %load and save config
        config=process_input(config,save_fname);
end
end



function config=process_input(config,save_fname)
%% Verify inputs
% try
    assert(isnumeric(config.batch_num),'Error. batch_num is not a number.\n')
    assert(isnumeric(config.startingsliceidx),'Error. startingsliceidx is not a number.\n')
    assert(config.use_predefined_thresh==0||config.use_predefined_thresh==1,'Error. use_predefined_thresh should be 0 or 1.\n')
    assert(ischar(config.codebook_name),'Error. codebook_name is not valid.\n')
    assert(ischar(config.codebookhyb_name),'Error. codebookhyb_name is not valid.\n')
    assert(config.is_barcoded==0||config.is_barcoded==1,'Error. is_barcoded should be 0 or 1.\n')
    assert(isnumeric(config.count_thresh),'Error. count_thresh is not a number.\n')
    assert(isnumeric(config.err_corr_thresh),'Error. err_corr_thresh is not a number.\n')
    assert(size(config.hybthresh,2)==4,'Error. hybthresh should be an n x 4 matrix.\n')
    assert(size(config.hybbgn,2)==4,'Error. hybbgn should be an n x 4 matrix.\n')
    assert(size(config.rolthresh,2)==4,'Error. rolthresh should be an n x 4 matrix.\n')

% for backward compatibility with scope_name
if isfield(config,'scope_name')&&~isfield(config,'scope_settings_file')
    warning('Configuration file contains scope_name instead of scope_settings. Automatically generate scope_settings file name.\n');
    config.scope_settings_file=[config.scope_name,'.json'];
else
    assert(ischar(config.scope_settings_file),'Error. scope_settings is not valid.\n')
end




% are slice numbers provided?
if isfield(config,'slice_num')
    assert(isnumeric(config.slice_num),'Error. slice_num is not a number.\n');
else
    warning('slice number is not provided. Will use default slice numbers');
    config.slice_num=[];
end

%% add additional inputs
if isfile(config.codebook_name)&&isfile(config.codebookhyb_name)
    config.codebook=load(config.codebook_name);
    config.codebookhyb=load(config.codebookhyb_name);
else
    error('Codebooks do not exist.\n')
end

%% load scope settings
try
    config.scope_settings=load_scope_settings(config.scope_settings_file);
catch
    error('Error loading scope setting file. Does the scope setting file exist?');
end



S=load(config.scope_settings.chprofile20x_name,'chprofile20x');
config.scope_settings.chprofile20x=S.chprofile20x;
if  strcmp(config.scope_settings.scope_name,'alder' ) % deal with old chshift format used for alder
    S=load(config.scope_settings.chshift20x_name,'chshift20x');
    config.scope_settings.chshift20x=S.chshift20x;
else
    S=load(config.scope_settings.chshift20x_name,'chshift20x_tform');
    config.scope_settings.chshift20x=S.chshift20x_tform;
end


%% save inputs for record keeping and for a01
save(save_fname,'config');
end

    


%% Moved to separate json files for each scope. scope settings, ALWAYS LOWERCASE!
% alder_settings=struct;
% alder_settings.chprofile20x_name='chprofile20x-50-30-20-40-20220218.mat';
% alder_settings.chshift20x_name='chshift20x-20220218.mat';
% alder_settings.chprofilehyb=[...
%     1 0 0 0;...
%     0.52 1 0 0;...
%     0 0 1 0;...
%     0 0 0 1];
% alder_settings.chshifthyb=[...
%     0 -3;...
%     0 0;...
%     0 0;...
%     -1 4 ...
%     ]; 
% alder_settings.automation=0;
% 
% alder_settings.gene_rgb_intensity=0.6;
% alder_settings.gene_max_thresh=2000;
% alder_settings.opt_rgb_intensity=0.6;
% alder_settings.opt_max_thresh=2000;
% alder_settings.bc_rgb_intensity=0.6;
% alder_settings.max_thresh_bc=1000;
% 
% alder_settings.hyb_radius=100; %radius for bgn subtraction of all channels.
% alder_settings.hyb_regchradius=30; % bgn radius for seq rolony cycle
% alder_settings.hyb_rgb_intensity=0.6;
% 
% alder_settings.stitch_overlap=0.23;
% alder_settings.stitch_xcam=3200;
% alder_settings.stitch_ycam=3200;
% alder_settings.cam_pixel=0.33;
% 
% alder_settings.registration_intensity_scaling=3;
% alder_settings.bc_registration_intensity_scaling=3;
% 
% 
% 
% % need to update these:
% birch_settings=struct;
% birch_settings.chprofile20x_name='chprofile20x-scope2-20230517.mat';
% birch_settings.chshift20x_name='chshift20x-scope2-20230510.mat';
% birch_settings.chprofilehyb=[...
%     1 0 0 0;...
%     0.52 1 0 0;...
%     0 0 1 0;...
%     0 0 0 1];
% birch_settings.chshifthyb=[...
%     0 -3;...
%     0 0;...
%     0 0;...
%     -1 4 ...
%     ];
% birch_settings.automation=1; 
% 
% birch_settings.gene_rgb_intensity=0.3;
% birch_settings.gene_max_thresh=4000;
% birch_settings.opt_rgb_intensity=0.3;
% birch_settings.opt_max_thresh=4000;
% birch_settings.bc_rgb_intensity=0.3;
% birch_settings.max_thresh_bc=2000;
% 
% birch_settings.hyb_radius=100; %radius for bgn subtraction of all channels.
% birch_settings.hyb_regchradius=30; % bgn radius for seq rolony cycle
% birch_settings.hyb_rgb_intensity=0.3;
% 
% birch_settings.stitch_overlap=0.10;
% birch_settings.stitch_xcam=2048;
% birch_settings.stitch_ycam=2048;
% birch_settings.cam_pixel=0.33;
% 
% birch_settings.registration_intensity_scaling=3;
% birch_settings.bc_registration_intensity_scaling=3;
% 
% 
% cypress_settings=struct;
% cypress_settings.chprofile20x_name='chprofile20x-cypress-20231122.mat';
% cypress_settings.chshift20x_name='chshift20x-scopeCypress-20231218.mat';
% cypress_settings.chprofilehyb=[...
%     1 0 0 0;...
%     0.52 1 0 0;...
%     0 0 1 0;...
%     0 0 0 1];
% cypress_settings.chshifthyb=[...
%     0 -3;...
%     0 0;...
%     0 0;...
%     -1 4 ...
%     ]; 
% cypress_settings.automation=0;
% 
% cypress_settings.gene_rgb_intensity=0.6;
% cypress_settings.gene_max_thresh=2000;
% cypress_settings.opt_rgb_intensity=0.6;
% cypress_settings.opt_max_thresh=2000;
% cypress_settings.bc_rgb_intensity=0.6;
% cypress_settings.max_thresh_bc=1000;
% 
% cypress_settings.hyb_radius=100; %radius for bgn subtraction of all channels.
% cypress_settings.hyb_regchradius=30; % bgn radius for seq rolony cycle
% cypress_settings.hyb_rgb_intensity=0.6;
% 
% cypress_settings.stitch_overlap=0.23;
% cypress_settings.stitch_xcam=3200;
% cypress_settings.stitch_ycam=3200;
% cypress_settings.cam_pixel=0.33;
% 
% cypress_settings.registration_intensity_scaling=3;
% cypress_settings.bc_registration_intensity_scaling=3;
% 
% 
% dogwood_settings=struct;
% dogwood_settings.chprofile20x_name='chprofile20x_dogwood_20240709.mat';
% %dogwood_settings.chprofile20x_name='chprofile20x_temp_20240702.mat';
% dogwood_settings.chshift20x_name='chshift20x_dogwood_20240709.mat';
% % dogwood_settings.chprofilehyb=[...
% %     1 0 0 0;...
% %     0.52 1 0 0;...
% %     0 0 1 0;...
% %     0 0 0 1];
% dogwood_settings.chprofilehyb=[...
%     1 0.03 0 0;...
%     0.15 1 0 0;...
%     0 0 1 0.09;...
%     0 0 0 1];
% % dogwood_settings.chshifthyb=[...
% %     0 -3;...
% %     0 0;...
% %     0 0;...
% %     -1 4 ...
% %     ]; 
% dogwood_settings.chshifthyb=[...
%     0 3;...
%     0 0;...
%     0 0;...
%     -1 -4 ...
%     ]; % updated 2024/08/05 based on data
% dogwood_settings.automation=1;
% 
% dogwood_settings.gene_rgb_intensity=0.6;
% dogwood_settings.gene_max_thresh=2000;
% dogwood_settings.opt_rgb_intensity=0.6;
% dogwood_settings.opt_max_thresh=2000;
% dogwood_settings.bc_rgb_intensity=0.6;
% dogwood_settings.max_thresh_bc=1000;
% 
% dogwood_settings.hyb_radius=100; %radius for bgn subtraction of all channels.
% dogwood_settings.hyb_regchradius=30; % bgn radius for seq rolony cycle
% dogwood_settings.hyb_rgb_intensity=0.6;
% 
% dogwood_settings.stitch_overlap=0.23;
% dogwood_settings.stitch_xcam=3200;
% dogwood_settings.stitch_ycam=3200;
% dogwood_settings.cam_pixel=0.33;
% 
% dogwood_settings.registration_intensity_scaling=3;
% dogwood_settings.bc_registration_intensity_scaling=3;
% 
% 
% %elm 
% elm_settings=struct;
% elm_settings.chprofile20x_name='chprofile20x-Elm-20240228.mat';
% elm_settings.chshift20x_name='chshift20x-Elm-20240228.mat';
% elm_settings.chprofilehyb=[...
%     1 0 0 0;...
%     0.52 1 0 0;...
%     0 0 1 0;...
%     0 0 0 1];
% elm_settings.chshifthyb=[...
%     0 -3;...
%     0 0;...
%     0 0;...
%     -1 4 ...
%     ]; 
% elm_settings.automation=0;
% 
% elm_settings.gene_rgb_intensity=0.6;
% elm_settings.gene_max_thresh=2000;
% elm_settings.opt_rgb_intensity=0.6;
% elm_settings.opt_max_thresh=2000;
% elm_settings.bc_rgb_intensity=0.6;
% elm_settings.max_thresh_bc=1000;
% 
% elm_settings.hyb_radius=100; %radius for bgn subtraction of all channels.
% elm_settings.hyb_regchradius=30; % bgn radius for seq rolony cycle
% elm_settings.hyb_rgb_intensity=0.6;
% 
% elm_settings.stitch_overlap=0.23;
% elm_settings.stitch_xcam=3200;
% elm_settings.stitch_ycam=3200;
% elm_settings.cam_pixel=0.33;
% 
% elm_settings.registration_intensity_scaling=3;
% elm_settings.bc_registration_intensity_scaling=3;
% 
% %% lookup table from scope names to scope settings
% scope_settings=dictionary( ...
%     'alder',alder_settings, ...
%     'birch',birch_settings, ...
%     'cypress',cypress_settings, ...
%     'dogwood',dogwood_settings, ...
%     'elm',elm_settings ...
%     );
